define(['HealthMoodSummaryController', 'HealthMoodConstants', 'moment'], function() {
	'use strict';

	describe("The Health Summary Controller", function (){
		var q,
			scope,
			stateParams,
			serviceMock,
			graphServiceMock,
			remindersServiceMock,
			focusServiceMock,
			idGetterSpy,
			fetchSpy,
			dataPointers = {},
			dateRange = {
				startDate: moment().subtract(3, 'months').format('L'),
				endDate: moment().format('L')
			},
			section = "glucose",
			sectionName = "Glucose",
			summaryType = "table",
			itemId = "item_id",
			parsedItemId = "parsed_item_id";

		beforeEach(function() {
			module('angularTemplateApp');

			serviceMock = jasmine.createSpyObj('HealthMoodService', ['instance']);
			graphServiceMock = jasmine.createSpyObj('HealthMoodGraphService', ['getGraphConfig']);
			remindersServiceMock = jasmine.createSpyObj('HealthMoodRemindersService', ['init', 'getReminder']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
			idGetterSpy = jasmine.createSpy("idGetterSpy").and.returnValue(parsedItemId);
			fetchSpy = jasmine.createSpy("fetchSpy");

			module(function($provide){
				$provide.value('HealthMoodService', serviceMock);
				$provide.value('HealthMoodGraphService', graphServiceMock);
				$provide.value('HealthMoodRemindersService', remindersServiceMock);
				$provide.value('focusService', focusServiceMock);
			});

			inject(function($controller, $rootScope, $stateParams, $state, $q) {
				scope = $rootScope.$new();
				stateParams = $stateParams;

				q = $q;

				var deferred = q.defer();
				serviceMock.instance.and.returnValue({
					dataPointers: dataPointers,
					idGetter: idGetterSpy,
					fetch: fetchSpy
				});
				deferred.resolve('resolved');
				fetchSpy.and.returnValue(deferred.promise);

				var deferredReminder = q.defer();
				deferredReminder.resolve('resolved');
				remindersServiceMock.getReminder.and.returnValue(deferredReminder.promise);

				stateParams.section = section;
				$state.current.data = {
					sectionName: sectionName
				};

				$controller('HealthMoodSummaryController', { $scope: scope, $stateParams: stateParams });
			});
		});

		describe("scope variables", function() {
			it("should be defined and correct", function() {
				scope.$apply();
				expect(scope.navButtons.right.length).toEqual(2);
				expect(scope.filter.service).toEqual(serviceMock.instance(section));
				expect(scope.filter.defaults).toEqual(dateRange);
				expect(scope.filter.callbacks.filter).toBeDefined();
				expect(scope.sectionTitle).toBe(sectionName);
				expect(scope.summaryType).toBe(summaryType);
				expect(scope.allowedDateRange).toEqual({min: moment().subtract(6, 'year').format('L')});
				expect(scope.notificationDetails).toEqual('resolved');
			});
		});

		describe("scope functions", function() {
			var stateSpy;

			beforeEach(inject(function($state){
				stateSpy = spyOn($state, "go");
			}));

			it("should just redirect for new entry", function() {
				scope.getDetails();

				expect(stateParams.id).toBe(null);
				expect(stateSpy).toHaveBeenCalledWith("^.entry", stateParams);
			});

			it("should get details and redirect for current entry", function() {
				scope.getDetails(itemId);

				expect(idGetterSpy).toHaveBeenCalledWith(itemId);
				expect(stateParams.id).toBe(parsedItemId);
				expect(stateSpy).toHaveBeenCalledWith("^.entry", stateParams);
			});

			it("should return appropriate info for graph/table button", function() {
				scope.navButtons.right[0].onClick();
				expect(scope.summaryType).toEqual("graph");
				expect(scope.navButtons.right[0].getLabel()).toEqual("Table");
				expect(scope.navButtons.right[0].getIcon()).toEqual("icon-list");

				scope.navButtons.right[0].onClick();
				expect(scope.summaryType).toEqual("table");
				expect(scope.navButtons.right[0].getLabel()).toEqual("Graph");
				expect(scope.navButtons.right[0].getIcon()).toEqual("icon-graph");
			});

			it("should update filter after searching", function() {
				var items = [{method: "After Meal"}, {method: "Unknown"}];
				scope.filter.model.tested = "After Meal";
				scope.filter.callbacks.filter(items);
				expect(dataPointers.list).toEqual([{method: "After Meal"}]);
			});
		});
	});
});